﻿var panelAttributeEditor = {
    datatable: null,
    currentData: null,
    initializeDataTable: function () {

        this.datatable = $(".v-attributeTable").a4datatable({
            ajaxAction: a4.getAction("GetPanelistAttributesGridResult", "Panelists", "Panel"),
            ajaxParams: { "attributeData": panelAttributeEditor.currentData },
            displayColumnSelector: false,
            columns: [
                { "Name": "Id", "Title": resources.Id, "Data": "Id"},
                { "Name": "Name", "Title": resources.Name, "Data": "Name", "Key": true },
                { "Name": "Type", "Title": resources.Type, "Data": "Type" }
            ],
            style: "compact" 
        });
    },
    selectAttributes: function (attributeNames) {
        var selectedAttributes = [];
        var attributes = [];

        if (panelAttributeEditor.currentData)
            selectedAttributes = JSON.parse(panelAttributeEditor.currentData);

        var id = 0;
        var column = 1;
        var rank = 1;
        var record = 1;

        _.each(attributeNames, function (attributeName, index) {
            if (attributeName) {
                var attribute = _.find(selectedAttributes, function (attribute) {
                    return attribute.Name == attributeName;
                });

                if (attribute) {
                    id = attribute.Id;
                    column = attribute.PositionColumn;
                    rank = attribute.PositionRank;
                    record = attribute.PositionRecord;
                }
                else {
                    column = 1;
                    rank++;
                    record = 1;
                }

                attributes.push({ "Id": id, "Name": attributeName, "PositionColumn": column, "PositionRank": rank, "PositionRecord": record });
            }
        });

        if (attributeNames) {
            a4.callServerMethod(a4.getAction("GetAttributeEditorData", "Panelists", "Panel"), { attributes: JSON.stringify(attributes) },
                function (result) {
                    panelAttributeEditor.refreshGrid(result);
                });
        }
        else {
            panelAttributeEditor.refreshGrid("");
        }
    },
    refreshGrid: function (data) {
        panelAttributeEditor.currentData = data;

        if (panelAttributeEditor.datatable) {
            panelAttributeEditor.datatable.a4datatable("option", "ajaxParams", { "attributeData": data, "sort": false });
            panelAttributeEditor.datatable.a4datatable("refresh");
        }
        else {
            panelAttributeEditor.initializeDataTable();
        }

        a4.parent().SetAttributesSelection(data);
    },
    initPanelAttributeEditor: function () {
        panelAttributeEditor.currentData = $("#JSONAttributes").val();
        panelAttributeEditor.initializeDataTable();
    }
}